package com.dxiot.read.idcard.service;

import android.content.Context;
import android.util.Log;

import com.alibaba.fastjson.JSONObject;
import com.dxiot.read.idcard.listener.OnReadCardListener;
import com.dxiot.read.idcard.utils.ByteUtils;
import com.eidlink.idocr.sdk.EidDeviceType;
import com.eidlink.idocr.sdk.EidLinkSE;
import com.eidlink.idocr.sdk.EidLinkSEFactory;
import com.eidlink.idocr.sdk.IDOCRCardType;
import com.eidlink.idocr.sdk.bean.EidlinkInitParams;
import com.eidlink.idocr.sdk.bean.EidlinkResult;
import com.eidlink.idocr.sdk.listener.EidLinkReadCardCallBack;
import com.eidlink.idocr.sdk.listener.OnGetResultListener;
import com.vf106.nfc.NfcJni;

public class ReadCardService {

    public static final int NORMAL_CARD = 0;
    public static final int ID_CARD = 1;

    private static String appid = "TESTID20220113103425";
    private static String ip = "devicetestid.dxiot.com";
    private static int envCode = 26814;
    private static int port = 9989;

//    public static String appid = "01SJ2202211328018232";
//    public static String ip = "deviceid.dxiot.com";
//    public static int envCode = 52302;
//    public static int port = 9989;

    public static EidLinkSE eid;
    private final NfcJni nfcJni;

    private long startTime, endTime;
    public boolean isStopThread = false;

    private OnReadCardListener mListener;

    private static volatile ReadCardService instance;

    public static ReadCardService getInstance() {
        if (instance == null) {
            synchronized (ReadCardService.class) {
                if (instance == null) {
                    instance = new ReadCardService();
                }
            }
        }
        return instance;
    }

    public ReadCardService() {
        nfcJni = new NfcJni();
    }

    public void init(Context context) {
        eid = EidLinkSEFactory.getEidLinkSE(new EidlinkInitParams(context, appid, ip, port, envCode));
        eid.setGetDataFromSdk(true);
        eid.setDeviceType(EidDeviceType.SN);

        int ret = nfcJni.nfcInit();
        if (ret < 0) {
            Log.e("ReadCardService", "nfc open failed,code=" + ret);
        } else {
            Log.i("ReadCardService", "nfc open success,code=" + ret);
        }
    }

    public void setOnReadCardListener(OnReadCardListener listener) {
        this.mListener = listener;
    }

    public void release() {
        stop();
        nfcJni.finishCard();
        nfcJni.exitCard();
    }

    public void start(int cardType) {
        isStopThread = false;
        Log.i("ReadCardService", "startThread================");
        Thread thread = new Thread(() -> {
            while (!isStopThread) {
                String cardInfo = nfcJni.getCardInfo(300);
                Log.i("ReadCardService", "card info:" + cardInfo);
                if (mListener != null) {
                    mListener.onReadCardSuccess(cardInfo);
                }

                if (cardType == ID_CARD) {
                    String[] split = cardInfo.split(":");
                    if (!cardInfo.equals("") && split.length == 2 && split[0].equals("6")) {
                        eid.readIDCard(IDOCRCardType.IDCARD, eidLinkReadCardCallBack, mResultListener);
                    }
                }
            }
        });
        thread.start();
    }


    public void stop() {
        isStopThread = true;
    }

    private final OnGetResultListener mResultListener = new OnGetResultListener() {
        @Override
        public void onSuccess(EidlinkResult result) {
            endTime = System.currentTimeMillis() - startTime;
            Log.i("ReadCardService", "Card read successfully  " + JSONObject.toJSONString(result) + "\ntime-consuming: " + endTime + "ms");
            if (mListener != null) {
                mListener.onSuccess(JSONObject.toJSONString(result.identity));
            }
            nfcJni.finishCard();
        }

        @Override
        public void onFailed(int code, String msg, String biz_id) {
            Log.e("ReadCardService", "Failed to read card: Error code=" + code + ",msg = " + msg + ",biz_id = " + biz_id);
            if (mListener != null) {
                mListener.onFailed(code, msg, biz_id);
            }
            nfcJni.finishCard();
        }

        @Override
        public void onStart() {
            super.onStart();
            startTime = System.currentTimeMillis();
            Log.i("ReadCardService", "Start reading the card.");
            if (mListener != null) {
                mListener.onReadCardStart();
            }
        }
    };

    private final EidLinkReadCardCallBack eidLinkReadCardCallBack = new EidLinkReadCardCallBack() {
        @Override
        public byte[] transceiveTypeB(byte[] bytes) {
            //Filtering two read commands 050000 or 1D0000000000080108
            Log.i("transceiveTypeB", ByteUtils.byte2Hex(bytes));
            if ("050000".equals(ByteUtils.byte2Hex(bytes)) || "1D0000000000080108".equals(ByteUtils.byte2Hex(bytes))) {
                return ByteUtils.hex2Byte("6D00");
            }
            return nfcJni.nfcSendApdu(1, bytes);
        }

        @Override
        public byte[] transceiveTypeA(byte[] bytes) {
            return null;
        }
    };
}
